<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;

class Admin extends BaseCommand
{
    /**
     * The Command's Group
     *
     * @var string
     */
    protected $group = 'App';

    /**
     * The Command's Name
     *
     * @var string
     */
    protected $name = 'Admin:module';

    /**
     * The Command's Description
     *
     * @var string
     */
    protected $description = '';

    /**
     * The Command's Usage
     *
     * @var string
     */
    protected $usage = 'command:name [arguments] [options]';

    /**
     * The Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * The Command's Options
     *
     * @var array
     */
    protected $options = [];

    /**
     * Actually execute a command.
     *
     * @param array $params
     */
    public function run(array $params): void
    {
       $sistematlan =
           <<<EOL
     _     _                       _   _             
 ___(_)___| |_ ___ _ __ ___   __ _| |_| | __ _ _ __  
/ __| / __| __/ _ \ '_ ` _ \ / _` | __| |/ _` | '_ \ 
\__ \ \__ \ ||  __/ | | | | | (_| | |_| | (_| | | | |
|___/_|___/\__\___|_| |_| |_|\__,_|\__|_|\__,_|_| |_|
EOL;

       CLI::write($sistematlan);
       if(empty($params))
       {
           $module =  CLI::prompt("¿Cual es el nombre del módulo que desea generar? ");
       }
       $module=$params[0];
       $module = strtoupper($module);

       CLI::write("Generando migración ... ");
       command("make:migration", $module."Table");
        CLI::write("Generando modelo ... ");

       command("make:model", $module."Model");
        CLI::write("Generando controlador ... ");

       command("make:controller", $module);
        CLI::write("Generando entity ... ");

       command("make:entity", $module);

       CLI::write("Listo!");
    }
}
