<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::login');

//app
$routes->get('/entrar', 'Home::login');
$routes->get('/inicio', 'Home::start',["filter" => "loggedIn"]);

//admin
$routes->get('/articulos', 'Article::list',["filter" => "loggedIn"]);
$routes->get('/tiendas', 'Store::list',["filter" => "loggedIn"]);
$routes->get('/gastos', 'Expense::list',["filter" => "loggedIn"]);
$routes->get('/ventas', 'Sale::list',["filter" => "loggedIn"]);
$routes->get("/ticket/(:any)","Sale::ticket/$1",["filter" => "loggedIn"]);

// resources
$routes->resource('sale',["filter" => "loggedIn"]);
$routes->resource('article',["filter" => "loggedIn"]);
$routes->resource('store',["filter" => "loggedIn"]);
$routes->resource('expense',["filter" => "loggedIn"]);
$routes->resource('cashout',["filter" => "loggedIn"]);

//playground
$routes->view('/ticket', 'ticket/saleTicket');
$routes->get("/dummy","Home::dummy");

service('auth')->routes($routes);
