<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CashoutModel;
use App\Models\PaymentModel;
use App\Models\SaleModel;
use CodeIgniter\HTTP\ResponseInterface;

class Cashout extends BaseController
{
    protected CashoutModel $cashoutModel;

    public function __construct()
    {
        $this->cashoutModel = new CashoutModel();
    }

    public function index()
    {
        //
    }
    public function show(...$dates):string
    {
        $tickets = '';
        $data = [];
        $data["types"] = [
            "cash"=>"EFE",
            "card"=>"TAR",
            "transfer"=>"TR",
            "credit"=>"CR"
        ];
        $salesModel = new SaleModel();
        $paymentModel = new PaymentModel();
        foreach($dates as $date)
        {

            $data["sales"] = $salesModel
                ->select("sales.*,customers.name")
                ->join("customers","customers.id=sales.customer")
                ->where('date(sales.created_at)', $date)
                ->findAll();


            $data["partials"] = $paymentModel
                ->select([
                    "payments.*",
                    "sales.id as sale"
                ])
                ->join("sales","sales.id=payments.sale")
                ->where(['date(payments.created_at)'=> $date])
                ->where("payments.credit is not null")

                ->findAll();

            $tickets  .= view("tickets/ticket_report",$data);

        }
//        dd($data);


        return $tickets;
    }
    public function create()
    {
        $today = $this->cashoutModel->where('date(created_at)', date("Y-m-d"))->first();

        $cashout = $today?? new \App\Entities\Cashout();
        $paymentModel = new PaymentModel();

        $payments = $paymentModel
            ->selectsum("amount")
            ->where("date(created_at)", date("Y-m-d"))
            ->first();

        $cashout->amount= $payments->amount;
        $save = $this->cashoutModel->save($cashout);
        $cashout->id = $this->cashoutModel->getInsertID();
        return $save? $this->response
            ->setStatusCode(ResponseInterface::HTTP_CREATED)
            ->setJSON($cashout):
            $this->response->setJSON($paymentModel->errors());
    }
}
