<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ExpenseModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;

class Expense extends BaseController
{
    use ResponseTrait;
    private ExpenseModel $expenseModel;

    public function __construct()
    {
        $this->expenseModel = new ExpenseModel();
    }

    public function index()
    {
        $expenses = $this->expenseModel->findAll();

        return $this->respond($expenses);
    }

    public function create(): ResponseInterface
    {
        $expense = new \App\Entities\Expense($this->request->getPost());

        try {
            $inserted = $this->expenseModel->save($expense);
        } catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());

        }
        return $inserted
            ? $this->respondCreated($this->expenseModel->find($this->expenseModel->getInsertID()))
            : $this->fail($this->expenseModel->errors());
    }

    public function list()
    {
        $data['path'] = 'Gastos';
        return view('expense/list', $data);
    }

    public function delete($id)
    {
        return $this->respondDeleted($this->expenseModel->delete($id));
    }
}
