<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class ExpenseTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "auto_increment"=>true,
                "unsigned"=>true,
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"10,2" ,
                "null"=>false,
            ],
            "description"=> [
                "type"=>"varchar",
                "constraint"=>250,
                "null"=>true,
            ],
            "category"=>[
                "type"=>"varchar",
                "constraint"=>100,
            ],
            "created_at"=>[
                "type"=>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type"=>"datetime",
                "null"=>true
            ],
            "deleted_at"=>[
                "type"=>"datetime",
                "null"=>true
            ]
        ]);
        $this->forge->addPrimaryKey("id")
            ->createTable("expenses",true,["ENGINE"=>"InnoDB"]);
    }

    public function down()
    {
        $this->forge->dropTable('expenses');
    }
}
