<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class PaymentsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"int",
                "constraint"=>11,
                "unsigned"=>true,
                "auto_increment"=>true,
            ],
            "sale"=>[
                "type"=> "int",
                "constraint"=>11,
                "unsigned"=>true,
                "null" => true,
                "after"=>"credit"
            ],
            "payment_type"=>[
                "type"=>"enum",
                "constraint"=>["cash","transfer","card"],
                "default"=>"cash"
            ],

            "aut"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "default"=>0,
                "null"=>true,
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"11,2",
            ],
            "cash"=>[
                "type"=> "decimal",
                "constraint"=>"10,2",
                "unsigned"=>true,
                "null" => true,
                "after"=>"amount"
            ],
            "cashback"=>[
                "type"=> "decimal",
                "constraint"=>"10,2",
                "unsigned"=>true,
                "null" => true,
                "after"=>"cash"
            ],

            "created_by"=>[
                "type"=>"int",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "document"=>[
                "type"=>"varchar",
                "constraint"=>250,
                "null"=>true
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]
        ])->addPrimaryKey("id")
            ->addForeignKey("sale","sales","id")
            ->createTable("payments",true,["ENGINE"=>"InnoDB"]);
    }

    public function down()
    {
        //
    }
}
