<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class CashoutTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "auto_increment"=>true
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
            ],
            "created_at"=>[
                "type"=>"datetime",
                "default"=>new RawSql("CURRENT_TIMESTAMP"),
            ]
        ])->addPrimaryKey("id")
            ->createTable("cashouts");
    }

    public function down()
    {
        //
    }
}
