<?php

namespace App\Services;

use App\Entities\Article;
use App\Entities\Price;
use App\Models\PriceModel;

class PriceService
{
    private PriceModel $priceModel;

    public function __construct()
    {
        $this->priceModel = new PriceModel();
    }

    /**
     * @throws \ReflectionException
     */
    public function setPrice(Article $article):bool
    {
        $prices = [];
        foreach($article->price as $price)
        {
            $price = new Price([
                "store"     =>  1,
                "article"   =>  $article->id,
                "name"      => $price["name"],
                "amount"    => $price["amount"],
            ]);
            $prices[] = $price;
        }
        return $this->priceModel->insertBatch($prices);
    }

}