<?php
namespace App\Services;

use App\Entities\Sale;
use App\Entities\SaleItem;
use App\Models\SaleItemModel;

class SaleItemService
{
  
    protected SaleItemModel $saleItemsModel;
    
    public function __construct()
    {
        $this->saleItemsModel = new SaleItemModel();
        
    }
    
    /**
     * @throws \ReflectionException
     */
    public function setSaleItems(Sale $sale, array $cart): array | false
    {
       # $inventoryService = new InventoryService();
        $cart = array_filter($cart);
        $items = [];
        $decreased = false;
        foreach ($cart as $key => $item)
        {
            $singleItem = new SaleItem([
                "sale" => $sale->id,
                "qty"=>$item["qty"],
                "article" => $item["id"],
                "sale_price" => $item["price"]["amount"],
                "unit_price" => $item["price"]["amount"],
                "final_price" => $item["subtotal"],
            ]);

            $items[] = $singleItem;
        }
        $saved = $this->saleItemsModel->insertBatch($items);
        return $saved?
            $this->saleItemsModel
            ->where(["sale"=>$sale->id])
            ->findAll():
            [];
    }
    
    public function getSaleItems(Sale $sale): ?array
    {
        return $this->saleItemsModel->where(["sale"=>$sale->id])->findAll();
    }
}




