<?= $this->extend('app/layout') ?>

<?= $this->section('viewStyles') ?>
<link rel="stylesheet" href="/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/bootstrap-select/bootstrap-select.css" />
<link rel="stylesheet" href="/assets/vendor/libs/sweetalert2/sweetalert2.css" />
<?= $this->endSection() ?>


<?= $this->section('content') ?>
    <?=$this->include('article/form')?>

    <?=$this->include('article/datatable')?>

    <?=$this->include('article/editModal')?>

<?= $this->endSection() ?>


<?= $this->section('viewScripts') ?>
<script src="/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="/assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script src="/assets/vendor/libs/jquery-repeater/jquery-repeater.js"></script>
<script src="/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script>
    console.log('Article JS loaded');
    var dt_basic_table = $('.datatables-basic');

    $(function(){
        var formRepeater = $('.repeater');
        $("form").on("submit",function(e){
            e.preventDefault();

        });
        if (formRepeater.length) {
            var row = 2;
            var col = 1;
            formRepeater.on('submit', function (e) {
                e.preventDefault();
            });
            formRepeater.repeater({
                show: function () {
                    var fromControl = $(this).find('input');
                   // var formLabel = $(this).find('.form-label');

                    fromControl.each(function (i) {
                        var id = 'form-repeater-' + row + '-' + col;
                        $(fromControl[i]).attr('id', id);
                    //    $(formLabel[i]).attr('for', id);
                        col++;
                    });

                    row++;

                    $(this).slideDown();
                },
                hide: function (e) {
                    confirm('Are you sure you want to delete this element?') && $(this).slideUp(e);
                }
            });
        }


        $('#updateArticle input,#selectpickerUpdateCategory').on('change', function () {
            let updateData = {
                '_method': 'PUT',
            }
            updateData[$(this).attr('name')] = $(this).val();
            updateArticle(updateData);
        });
    });

    // Article form

    //Datatable
    if (dt_basic_table.length) {
        dt_basic = dt_basic_table.DataTable({
            ajax: {
                url: '/article',
                dataSrc: ""
            },
            columns: [
                { data: '' },
                { data: 'id' },
                { data: 'id' },
                { data: 'name' },
                { data: 'category' },
                { data: 'cost' },
                { data: 'price.amount' },
                { data: 'delete_at' },
                { data: '' }
            ],
            columnDefs: [
                {
                    // For Responsive
                    className: 'control',
                    orderable: false,
                    searchable: false,
                    responsivePriority: 2,
                    targets: 0,
                    render: function (data, type, full, meta) {
                        return '';
                    }
                },
                {
                    // For Checkboxes
                    targets: 1,
                    orderable: false,
                    searchable: false,
                    responsivePriority: 3,
                    checkboxes: true,
                    render: function () {
                        return '<input type="checkbox" class="dt-checkboxes form-check-input">';
                    },
                    checkboxes: {
                        selectAllRender: '<input type="checkbox" class="form-check-input">'
                    }
                },
                {
                    targets: 2,
                    searchable: false,
                    visible: false
                },
                {
                    responsivePriority: 1,
                    targets: 4
                },
                {
                    // Actions
                    targets: -1,
                    title: 'Acciones',
                    orderable: false,
                    searchable: false,
                    render: function (data, type, full, meta) {
                        let articleJson = JSON.stringify(full);
                        return (
                            `<a href="javascript:;" onclick='openArticleModal(${articleJson})' class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit" data-bs-toggle="modal" data-bs-target="#editArticle"><i class="ri-pencil-fill"></i></a>
                            <a href="javascript:;" onclick='changeStatus(${articleJson})' class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-pause-circle-fill"></i></a>
                            <a href="javascript:;" onclick="deleteArticle(${full.id})" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-delete-bin-6-fill"></i></a>
                            `
                        );
                    }
                },
                {
                    // Status
                    targets: 7,
                    title: 'Estatus',
                    orderable: false,
                    searchable: false,
                    render: function (data, type, full, meta) {
                        let badge;
                        if(full.paused == 1){
                            badge = `<span class="badge bg-secondary">Pausado</span>`
                        }else {
                            badge = `<span class="badge bg-primary">Activo</span>`
                        }
                        return badge;
                    }
                }
            ],
            order: [[2, 'desc']],
            dom: '<"card-header flex-column flex-md-row border-bottom"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6 mt-5 mt-md-0"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
            displayLength: 7,
            lengthMenu: [7, 10, 25, 50, 75, 100],
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect waves-light',
                    text: '<i class="ri-external-link-line me-sm-1"></i> <span class="d-none d-sm-inline-block">Exportar</span>',
                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="ri-file-text-line me-1" ></i>CSV',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="ri-file-pdf-line me-1"></i>PDF',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                    ]
                }
            ],
            responsive: {
                details: {
                    display: $.fn.dataTable.Responsive.display.modal({
                        header: function (row) {
                            var data = row.data();
                            return 'Detalles del artículo';
                        }
                    }),
                    type: 'column',
                    renderer: function (api, rowIdx, columns) {
                        var data = $.map(columns, function (col, i) {
                            return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                ? '<tr data-dt-row="' +
                                col.rowIndex +
                                '" data-dt-column="' +
                                col.columnIndex +
                                '">' +
                                '<td>' +
                                col.title +
                                ':' +
                                '</td> ' +
                                '<td>' +
                                col.data +
                                '</td>' +
                                '</tr>'
                                : '';
                        }).join('');

                        return data ? $('<table class="table"/><tbody />').append(data) : false;
                    }
                }
            }
        });
        $('div.head-label').html('<h5 class="card-title mb-0">Relación de artículos</h5>');
    }

    function saveNewArticle()
    {
        let articleData = $("#newArticle,#article-price-form").serializeArray();

        $.ajax({
            method: "POST",
            url: "/article",
            dataType: "JSON",
            data: articleData,
        }).done(function(article){
            if(article.id != null){
                toastAlert('success','Artículo agregado', 'Listo para vender');
                dt_basic.ajax.reload();
            }else {
                toastAlert('error', 'Algo salio mal', 'Por favor, intenta de nuevo');
            }
        });
    }

    function openArticleModal(article)
    {
        document.getElementById("update-name").value = article.name;
        document.getElementById("update-cost").value = article.cost;
        document.getElementById("update-price").value = article.price.amount;
        document.getElementById("update-id").value = article.id;
        $('#selectpickerUpdateCategory').selectpicker('val',article.category.toLowerCase());
    }

    function updateArticle(update)
    {
        let id = $("#update-id").val();
        $.ajax({
            method: "POST",
            url: '/article/'+id,
            dataType: "JSON",
            data: update,
            statusCode: {
                200: function() {
                    toastAlert('success', 'Artículo actualizado', 'La información se actualizó correctamente');
                    dt_basic.ajax.reload();
                },
                400: function() {
                    toastAlert('warning', 'titulo', 'mensaje');
                },
                500: function() {
                    toastAlert('error', 'titulo', 'mensaje');
                }
            }
        });
    }

    function changeStatus(article)
    {
        let id = article.id;
        if(article.paused == 0){
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción solo pausara el artículo y no podrá ser vendido hasta que lo reactives",
                showCancelButton: true,
                confirmButtonText: 'Sí, pausar artículo!',
                cancelButtonText: 'Cancelar',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-outline-secondary waves-effect'
                },
                buttonsStyling: false
            }).then(function (result) {
                if (result.value) {
                    $.ajax({
                        method: "POST",
                        url: "/article/"+id,
                        dataType: "JSON",
                        data: {
                            _method: 'PUT',
                            'paused': 1
                        }
                    }).done(function(response){
                        if(response != null){
                            dt_basic.ajax.reload();
                            Swal.fire({
                                title: 'Artículo pausado!',
                                text: 'El artículo se pausó y no podrá venderse hasta que lo reactives',
                                customClass: {
                                    confirmButton: 'btn btn-success waves-effect'
                                }
                            });
                        }else{
                            toastAlert('error','Error','Ocurrió un problema al guardar');
                        }
                    });
                }
            });
        }else {
            $.ajax({
                method: "POST",
                url: "/article/"+id,
                dataType: "JSON",
                data: {
                    _method: 'PUT',
                    'paused': 0
                }
            }).done(function(response){
                if(response != null){
                    toastAlert('success','Artículo reactivado','El artículo esta disponible para su venta');
                    dt_basic.ajax.reload();
                }else{
                    toastAlert('error','Error','Ocurrió un problema al guardar');
                }
            });
        }

    }

    function deleteArticle(id)
    {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "No podrás recuperar este artículo una vez que lo hayas borrado",
            showCancelButton: true,
            confirmButtonText: 'Sí, borrar!',
            cancelButtonText: 'Cancelar',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-outline-secondary waves-effect'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.value) {
                $.ajax({
                    method: "DELETE",
                    url: "/article/"+id,
                    dataType: "JSON",
                }).done(function(response){
                    if(response != null){
                        dt_basic.ajax.reload();
                        Swal.fire({
                            title: 'Artículo borrado!',
                            text: 'El artículo se borró de la lista',
                            customClass: {
                                confirmButton: 'btn btn-success waves-effect'
                            }
                        });
                    }else{
                        toastAlert('error','Error','Ocurrió un problema al guardar');
                    }
                });
            }
        });
    }

</script>
<?= $this->endSection() ?>
