<?= $this->extend('app/layout') ?>

<?= $this->section('viewStyles')?>
    <link rel="stylesheet" href="/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css"/>
    <link rel="stylesheet" href="/assets/vendor/libs/bootstrap-select/bootstrap-select.css" />
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?php if(env('CI_ENVIRONMENT')==='development') : ?>
    <div class="alert alert-solid-warning" role="alert">
                            <span class="text-black">
                            ¡ATENCIÓN! <br> Estás en la versión de pruebas del sistema. <br> Si eres un vendedor o administrador visita
                                el siguiente <a  class="text-black" href="https://srpan.sistematlan.com">link.</a>
                            </span>
    </div>
<?php endif; ?>
    <div class="row">
        <div class="col-xl-8">
            <div class="card overflow-hidden" style="max-height:700px">
                <h5 class="card-header">Artículos disponibles</h5>
                <div class="px-6 row flex-nowrap" >
                    <?php
                        foreach ($categories as $key => $category) :
                    ?>
                        <button
                                type="button"
                                id=" <?=$category.$key?>"
                                value="<?=strtolower($category)?>"
                                class="btn col categoryBtnFilter rounded-pill btn-label-primary">
                            <?=$category?>
                        </button>
                    <?php
                        endforeach;
                    ?>
                </div>
                <div class="card-body"  id="vertical-example">
                    <div class="row row-cols-sm-1 row-cols-md-2 row-cols-lg-3" id="articleList">
                        <?php foreach($articles as $key => $article):?>
                           <div class="<?=$article->category?>">
                               <div class="form-check custom-option custom-option-basic" >
                                   <label class="form-check-label custom-option-content" for="CheckArticle<?=$article->id?>">
                                       <input class="form-check-input" type="checkbox" onchange='addToCart(<?=json_encode($article)?>,this)' value="" id="CheckArticle<?=$article->id?>" />
                                       <span class="custom-option-header">
                                            <span class="h6 mb-0"><?=$article->name?></span>
                                        </span>
                                       <span class="custom-option-body">
                                            <small class="mt-1">Precio: $<?=@$article->price->amount?> </small>
                                            <input
                                                    id="pieces-<?=$article->id?>"
                                                    type="text"
                                                    min="0"
                                                    readonly
                                                    onclick='showSwal(<?=json_encode($article)?>,this)'
                                                    class="form-control input-group-sm mt-1"
                                                    placeholder="1"
                                                    aria-label="Article pieces" />
                                          </span>
                                   </label>
                               </div>
                           </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4">
            <div class="card  mt-4 mt-lg-0">
                <div class="card-body">

                    <h4 class="mb-2">Método de pago</h4>
                    <!-- Payment method -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-12">
                            <div class="form-floating form-floating-outline">
                                <select id="paymentMethod" class="selectpicker w-100" data-style="btn-default">
                                    <option value="cash">Efectivo</option>
                                    <option value="card">Tarjeta Crédito/Debito</option>
                                    <option value="transfer">Transferencia</option>
                                </select>
                            </div>
                            <input
                                    type="text"
                                    name="aut"
                                    class="form-control mt-1 d-none"
                                    id="ticketNumber"
                                    placeholder="Numero de ticket"
                                    aria-label="Numero de ticket" />
                            <input
                                    type="number"
                                    name="cash"
                                    class="form-control mt-1 "
                                    id="cashreceived"
                                    placeholder="Recibí. Doble click para borrar"
                                    aria-label="Recibí" />
                            <input
                                    type="number"
                                    name="cashback"
                                    class="form-control mt-1 "
                                    id="cashback"
                                    placeholder="Cambio"
                                    aria-label="Cambio"
                                    readonly />
                        </div>
                    </div>

                    <hr class="mx-n3" />
                    <!-- Discount -->
                        <h6>Descuento</h6>
                        <div class="row g-3 mb-3">
                            <div class="col-sm-8 col-xxl-8 col-xl-12">
                                <input
                                        type="number"
                                        step=".01"
                                        value="0"
                                        class="form-control"
                                        id="discountValue"
                                        disabled
                                        placeholder="Monto a descontar"
                                        aria-label="Monto a descontar" />
                            </div>
                            <div class="col-12 col-md-4 mb-2">
                                <div class="d-grid">
                                    <button type="button" onclick="wip()" class="btn btn-outline-primary">Aplicar</button>
                                </div>
                            </div>
                        </div>
                        <div id="discountAlert" class="alert d-none alert-solid-primary d-flex align-items-center" role="alert">
                            <i class="mdi mdi-alert-circle-check-outline me-2"></i>
                            <span>¡Descuento aplicado!</span>
                        </div>


                    <h4 class="mb-2">Resumen del pedido</h4>

                    <small class="mb-6 text-muted">
                        Por favor, revisa con atención la cantidad <br> de artículos agregados al carrito.
                    </small>

                    <div class="bg-lighter mt-3 rounded-4">

                        <ul class="list-group" id="cart-items">


                        </ul>
                    </div>
                    <div class="mt-5">
                        <div class="d-flex justify-content-between align-items-center">
                            <p class="mb-0">Artículos:</p>
                            <h6 class="mb-0" id="sale-qty"></h6>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-2">
                            <p class="mb-0">Subtotal:</p>
                            <h6 class="mb-0" id="sale-subtotal"></h6>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-2">
                            <p class="mb-0">Descuento:</p>
                            <h6 class="mb-0" id="discountTxt"></h6>
                        </div>

                        <hr />

                        <div class="d-flex justify-content-between align-items-center pb-1">
                            <p class="mb-0">Total</p>
                            <h6 class="mb-0" id="total"></h6>
                        </div>

                        <div class="d-grid mt-5">
                            <button
                                    onclick="checkoutCart()"
                                    class="btn btn-primary">
                                <span class="me-1_5">Imprimir ticket</span>
                                <i class="ri-arrow-right-line ri-16px scaleX-n1-rtl"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Basic Custom Checkboxes -->
        </div>
    </div>
    <div class="content-backdrop fade"></div>
<?= $this->endSection() ?>
<?= $this->section('viewScripts') ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="/assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script>
    console.log('Sale JS loaded');
    const verticalExample = document.getElementById('vertical-example');
    const horizontalExample = document.getElementById('horizontal-example');
    let paymentType = $("#paymentMethod");
    let discountValue = $('#discountValue');
    let ticketNumber = $("#ticketNumber");
    let cashback = $("#cashback");
    let moneyReceived = $("#cashreceived");
    let totalToSale =  $('#total');
    let cart = {};
    let subtotal = 0;
    let sale = {
        store: 1,
        payment_type: paymentType.val(),
        type: 'cash',
        amount: 0,
        aut:'',
        discount :0,
        payment : {
            received :0,
            cashback:0
        }
    }

    $(function(){
        $("form").on("submit",e=>{
            e.preventDefault();
        })

        if (verticalExample) {
            new PerfectScrollbar(verticalExample, {
                wheelPropagation: false
            });
        }

        $('.categoryBtnFilter').on('click', function () {
            let selectedClass = this.value;
            console.log(this.value);
            if ($(this).hasClass('btn-primary')) {
                $(this).removeClass('btn-primary').addClass('btn-label-primary');
                $('#articleList > *').show();
            } else {
                $('.categoryBtnFilter').removeClass('btn-primary').addClass('btn-label-primary');

                $(this).removeClass('btn-label-primary').addClass('btn-primary');

                $('#articleList > *').hide();
                $(`#articleList .${selectedClass}`).show();
            }
        });

        moneyReceived
            .on("keyup",calculateCashback)
            .on("dblclick",clearPayment);

        //Ticker number for card method payment
        paymentType.on("change",function(e) {
            clearPayment();

            switch (this.value) {
                case "cash" :
                    $("#cashback, #cashreceived").removeClass("d-none");
                    ticketNumber.addClass("d-none");
                    break;
                case "card" :
                    $("#cashback, #cashreceived").addClass("d-none");
                    ticketNumber.removeClass("d-none");
                    break;
                case "transfer" :
                    ticketNumber.addClass("d-none");
                    $("#cashback, #cashreceived").addClass("d-none");
                    break;

                default : break;

            }
            sale.payment_type = this.value;
        });
    });

    function addToCart(item,checkbox)
    {
        if(checkbox.checked){

            $("#pieces-"+item.id)
                .val(1)
                .parent()
                .append(`
                    <div class="btn-group mt-3 w-100" role="group" aria-label="Basic example">
                        <button id="decrease-${item.id}" onclick='decrease(this,${JSON.stringify(item)})' class="btn btn-sm w-50 btn-outline-primary" type="button">-</button>
                        <button id="increase-${item.id}" onclick='increase(this,${JSON.stringify(item)})' class="btn btn-sm w-50 btn-outline-primary" type="button">+</button>
                    </div>
                `)

            setCartItem(item,1)

        }else{
            $("#pieces-"+item.id).val(0);
            $("button#increase-"+item.id).parent().remove();
            //$("button#decrease-"+item.id).remove();
            setCartItem(item,0)
        }


    }
    function showSwal(item,input)
    {
        Swal.fire({
            title: "Cuantas piezas?",
            input: "number",
            confirmButtonColor: "#c89260",
            inputAttributes: {
                min: "1",
                max: "120",
                step: "1"
            },
            inputValue: input.value
        }).then(pieces=>{

            if(pieces.isConfirmed){

                input.value =pieces.isConfirmed ? pieces.value :input.value
                setCartItem(item,input.value)
            }

        })
    }

    function decrease(btn,item)
    {
        let count = $("#pieces-"+item.id).val();
        $("#pieces-"+item.id).val(--count);
        console.log(count);
        if(count===0)
        {
            $("button#increase-"+id).remove();
            $("button#decrease-"+id).remove();
          //  $("#CheckArticle"+id).prop("checked",false);
        }
        setCartItem(item,count)

    }

    function increase(btn,item)
    {
        let count = $("#pieces-"+item.id).val();
        $("#pieces-"+item.id).val(++count);
        setCartItem(item,count)
    }

    function setCartItem(item,qty)
    {
        let price = parseFloat(item.price.amount);
        if(cart[item.id]===undefined) {
            cart[item.id] = {
                ...item,
                qty: qty,
                subtotal: qty * price
            };
        }else
        {
            cart[item.id].qty = qty;
            cart[item.id].subtotal= qty * price;

        }
        //$("#cart-items").append(item);
        setItemsQty();
        getSubtotal();
    }

    function setItemsQty()
    {
        let sum = 0;
        for(let item in cart)
        {
            sum += parseInt(cart[item].qty)

        }
        $("#sale-qty").text(sum);
        sale.items = sum;
    }

    function getSubtotal()
    {
        let sum = 0;
        for(let item in cart)
        {
           sum += cart[item].subtotal
        }
        $("#sale-subtotal")
            .text(
                new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' }).format(sum)
            );

        sale.amount = sum;
        getTotalSale(sale)
        //calculateTotal();
    }

    function getTotalSale(sale)
    {
        console.log(sale);
        let amount = sale.amount;
        $("#total").text( new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' }).format(amount))
    }

    function checkoutCart()
    {
        let voucher = sale.payment_type==='card'? ticketNumber.val():null;
        sale.aut = voucher;
        sale.cart = cart;
        $.ajax({
            method:"POST",
            url:"/sale",
            data : sale ,
            dataType: "JSON"
        }).done(sale=>{
            console.log(sale);
            window.open(`/ticket/${sale.uuid}`,"_blank","width:500,height:600,scrollbars:no")
        });
    }

    function calculateCashback(e=null)
    {
        debugger;
        if(null === e || isNaN(e.currentTarget.value) )
        {
            e.currentTarget.value = '';
            return false
        }
        let received = parseFloat(e.currentTarget.value);
        let cashBack = (undefined!== sale.amount)? received - sale.amount : null
        cashback.val(Number.isNaN(cashBack)?0:cashBack);
        if(cashBack>=0)
        {
            sale.payment.received=received,
            sale.payment.cashback=cashBack
        }
    }

    function clearPayment()
    {
        ticketNumber.val(null);
        moneyReceived.val(null);
        cashback.val(null);
    }

    function calculateTotal(displayAlert = false)
    {
        let finalPrice = 0;
        if(undefined=== discountValue.val())
        {
            finalPrice =  parseFloat( subtotal).toFixed(2);
        }else {
            discountAmount = parseFloat(discountValue.val());
            sale.discount = discountAmount;
            if (displayAlert){
                $('#discountAlert').removeClass('d-none');
                setTimeout(function(){
                    $('#discountAlert').addClass('d-none');
                }, 1000);
                $('#discount').text(formatMoney(discountAmount));
            }
            finalPrice =parseFloat(( subtotal- discountAmount).toFixed(2));

        }

        sale.amount = finalPrice;
        moneyReceived.trigger("keyup");
        updateTotal(formatMoney(parseFloat(finalPrice).toFixed(2)));
    }

    function updateTotal(total)
    {
        totalToSale.text(total);
        if(total ==="0")
        {
            moneyReceived.val(null);
            cashback.val(null);
        }
    }

    function saveSale()
    {
        let voucher = sale.payment_type==='card'? ticketNumber.val():null;
        sale.aut = voucher;
        console.log(sale);
    }


</script>
<?= $this->endSection() ?>