<!doctype html>

<html
    lang="en"
    class="light-style layout-wide"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="../../assets/"
    data-template="vertical-menu-template-no-customizer"
    data-style="light">
<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Ticket | <?=env('app.title')?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="../../assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="../../assets/vendor/fonts/remixicon/remixicon.css" />
    <link rel="stylesheet" href="../../assets/vendor/fonts/flag-icons.css" />

    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="../../assets/vendor/libs/node-waves/node-waves.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="../../assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="../../assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/typeahead-js/typeahead.css" />

    <!-- Page CSS -->

    <!--<link rel="stylesheet" href="../../assets/vendor/css/pages/app-invoice-print.css" />-->

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../assets/js/config.js"></script>
</head>

<body class="bg-white">
<!-- Content -->

<div class="invoice-print bg-white p-6">
    <div class="d-flex justify-content-between flex-row">
        <div>
            <div class="d-flex svg-illustration align-items-center gap-2 mb-6">
                <img src="/assets/img/srpan/logo_bw.png" class="w-px-75" alt="">
                <span class="mb-0 app-brand-text demo fw-semibold"><?=env('app.title')?> <br> Ticket de venta</span>
            </div>
            <div class="mb-1 text-sm small">
                <small>3ra Sur S/N entre Central Ote y 2da Ote</small> <br>
                <small>CP. 30700 | Tapachula, Chiapas</small> <br>
                <small>Tel. 962 521 9518</small>
            </div>
        </div>
    </div>


    <hr class="my-3" />

    <div class="mb-1 text-sm small">
        <small>Venta: <?=$sales->id?></small> <br>
        <small>UUID: <?=$sales->uuid?></small> <br>
        <small>Fecha y Hora: <?=$sales->created_at?></small> <br>
        <small>Método de pago: <?=$sales->payment_type?></small>
    </div>


    <hr class="my-3" />

    <div class="">
        <table class="m-0 text-sm">
            <thead>
            <tr>
                <th class="w-px-250">Artículo</th>
                <th class="w-px-75">Unit</th>
                <th class="w-px-50">Cant</th>
                <th class="w-px-75">Subto</th>
            </tr>
            </thead>
            <tbody>
            <?php
            if(isset($sales->sale_items)):
                foreach($sales->sale_items as $key => $item):
            ?>
            <tr>
                <td><?=$item->article_name->name?></td>
                <td>$<?=$item->unit_price?></td>
                <td><?=$item->qty?></td>
                <td>$<?=$item->final_price?></td>
            </tr>
            <?php
                endforeach;
                endif;?>
            </tbody>
        </table>
    </div>
    <div class="">
        <table class="m-0 table-borderless">
            <tbody>
            <tr>
                <td class="px-0 py-6 w-px-350">
                    <p class="mb-1">Subtotal:</p>
                    <p class="mb-1 border-bottom">Descuento:</p>
                    <p class="mb-0 pt-2">Total:</p>
                    <p class="mb-0 pt-2">Recibido:</p>
                    <p class="mb-0 pt-2">Cambio:</p>
                </td>
                <td class="px-0 py-6 w-px-100">
                    <p class="fw-medium mb-1">$<?=$sales->amount?></p>
                    <p class="fw-medium mb-1 border-bottom">$<?=$sales->discount?></p>
                    <p class="fw-medium mb-0 pt-2">$<?=$sales->amount?></p>
                    <p class="fw-medium mb-0 pt-2">$<?=$sales->cash?></p>
                    <p class="fw-medium mb-0 pt-2">$<?=$sales->amount - $sales->cash?></p>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
    <span> </span><br>
    <p class="mb-1 text-center small">
        <small>Muchas gracias por su preferencia</small> <br>
        <small>Sugerencias al teléfono: 962 521 9518</small> <br>

        <span> </span><br>

        <small class="text-sm small">Desarrollado en sistematlan.com/pos</small>
        <br>
        <br>
    </p>
</div>

<!-- / Content -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<!-- Core JS -->
<!-- <script src="../../assets/js/app-invoice-print.js"></script>-->
<script>
    $(function(){
        $(document).on("keyup",function (e){
            e.key==="Escape"?window.close():false;
        })
    })
    window.print()
</script>
</body>
</html>
