console.log('Global JS loaded');

/**
 * Muestra una alerta de notificación tipo "toast" en la interfaz de usuario.
 *
 * @function toastAlert
 * @param {string} type - El tipo de notificación que se desea mostrar. Puede ser uno de los siguientes valores: 'success', 'info', 'warning', 'error'.
 * @param {string} title - El título de la notificación.
 * @param {string} message - El mensaje de la notificación.
 *
 * @example
 * toastAlert('success', 'Operación exitosa', 'Los datos se guardaron correctamente');
 * toastAlert('error', 'Error', 'No se pudo conectar al servidor');
 */
function toastAlert(type, title, message)
{
    Command: toastr[type](message, title);

    toastr.options = {
        "closeButton": false,
        "debug": false,
        "newestOnTop": false,
        "progressBar": false,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    }
}

function wip()
{
    toastAlert('info', 'Módulo en desarrollo', 'Gracias por tu paciencia');
}
function toggleLoading(button) {

    console.log(button);
    (button === undefined)?

        $(".loading").html('').text("Guardar").prop("disabled",false):
        $(button)
            .prepend(`<span class="spinner-border me-1" role="status" aria-hidden="true"></span>`)
            .addClass("loading")
            //.prop("disabled",true);
}
function errorFromServer(xhr)
{
    toggleLoading();
    for (let message in xhr.responseJSON.messages)
    {
        console.log(message);
        toastAlert("error","Error Fatal",xhr.responseJSON.messages[message])
    }

}
function badRequest(xhr)
{
    toggleLoading();
    for (let message in xhr.responseJSON.messages)
    {
        console.log(message);
        toastAlert("error","Faltan datos",xhr.responseJSON.messages[message])
    }
}

function formatMoney(price)
{
    return new Intl.NumberFormat().format(price);
}